
// BIEstimateSlip.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.


#ifdef BILLINGS_PRO
#import "_BPEstimateSlip.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIEstimateSlip.h"
#endif
#import "BIAppVersioning.h"


@class BISlipTemplate;
@class BITax;
@class BIProject;
@class MCPDatabaseObjectContext;
@class BIDatabaseObjectContext;
@class BICurrency;
@class BIClient;

/*!
    @class       BIEstimateSlip
    @abstract    BIEstimateSlip reperesents and estimate slip.
    @discussion  Handles all behaviour regarding Estimate Slips.  An estimate slip has reference to any working slips generated from it, mainly for reporting purposes in the future.  Estimate slips are usually created initially, so that a user can send a quote/estimate to the client.  Once the user has finalized an estimate, they will create working slips from an estimate slip, and the values of the estimate slip will be copied over to the working slip.
 
                 ISSUES
 
                 - we should move out the subtotal, markup, discount, total logic to another entity so we are not always repeating this logic.
                
                 - we should move out the tax calculation to another entity, tax manager should be good for this.

                 - we should remove all stale info, ie. old tax stuff.. tax1, tax2.
*/


@interface BIEstimateSlip : BL_SUPER_CLASSNAME_MUNGE(EstimateSlip) 
{
}

+ (NSString*)timeDisplayWithNumSeconds:(long)totalSec;

- (void)setDefaultValues;
- (void)setDefaultValuesWithObjectContext:(MCPDatabaseObjectContext*)oc;

- (id)quantityDuration;
- (void)setQuantityDuration:(id)aValue;

- (id)quantityDurationNilSafe;
- (void)setQuantityDurationNilSafe:(id)aValue;

- (BOOL)isDueDate;
- (void)setIsDueDate:(BOOL)flag;

- (BOOL)isCompleteDate;
- (void)setIsCompleteDate:(BOOL)flag;

- (BOOL)isStartDate;
- (void)setIsStartDate:(BOOL)flag;

- (BOOL)isSentInEstimate;
- (void)setIsSentInEstimate:(NSString*)aString;

- (NSString*)sentInEstimateDateString;
- (void)setSentInEstimateDateString:(NSString*)aString;

- (NSCalendarDate*)estimatedDate;
- (void)setEstimatedDate:(NSCalendarDate*)aDate;

- (NSString*)kindName;
- (void)setKindName:(NSString*)aName;

- (NSString*)natureName;
- (void)setNatureName:(NSString*)aName;

- (BOOL)realSlipExists;
- (void)setRealSlipExists:(BOOL)aFlag;

- (NSNumber*)derivedDiscountTotal;
- (void)setDerivedDiscountTotal:(NSNumber*)aTotal;

- (NSNumber*)derivedCombinedTaxTotal;
- (void)setDerivedCombinedTaxTotal:(NSNumber*)aTotal;

- (NSNumber*)tax1Total;
- (void)setTax1Total:(NSNumber*)aTotal;
//- (NSNumber*)calculateTax1TotalWithSubTotal:(NSNumber*)aSubTotal;

- (NSNumber*)tax2Total;
- (void)setTax2Total:(NSNumber*)aTotal;
//- (NSNumber*)calculateTax2TotalWithSubTotal:(NSNumber*)aSubTotal;

- (BOOL)useTax1Bool;
- (void)setUseTax1Bool:(BOOL)flag;

- (BOOL)useTax2Bool;
- (void)setUseTax2Bool:(BOOL)flag;

- (BOOL)compoundSecondaryTaxBool;
- (void)setCompoundSecondaryTaxBool:(BOOL)flag;

- (long)numHoursFromDurationInSeconds:(long)aDuration;
- (long)numMinutesFromDurationInSeconds:(long)aDuration;

- (NSString *)formattedRate;

- (NSString *)formattedDerivedSubTotal;
- (NSNumber *)derivedSubTotal;
- (void)setDerivedSubTotal:(NSNumber*)aTotal;

- (NSNumber *)baseDerivedTotal;
- (NSNumber *)derivedTotal;
- (void)setDerivedTotal:(NSNumber*)aTotal;

- (NSNumber*)derivedMarkupTotal;
- (void)setDerivedMarkupTotal:(NSNumber*)aNumber;
- (NSNumber*)calculateMarkupTotalWithSubTotal:(NSNumber*)aSubTotal;

- (NSNumber*)derivedSubTotalForEstimate;
- (void)setDerivedSubTotalForEstimate:(NSNumber*)aTotal;

- (NSString*)mileageDisplayName;
- (void)setMileageDisplayName:(NSString*)aString;

- (NSString*)mileagePerDisplayName;
- (void)setMileagePerDisplayName:(NSString*)aString;

- (NSString*)quantityDurationString;
- (void)setQuantityDurationString:(NSString*)aString;

- (BOOL)hasWorkingSlips;

- (id)copyWithZone:(NSZone *)zone;

- (void)applyTemplate:(BISlipTemplate*)aTemplate;

- (NSArray*)contributeExportFields;
//- (NSArray*)expandKeysInExportFields:(NSArray*)fieldDicts;
- (NSArray*)dictionariesForExpandTaxTotals;
- (NSString*)tabDelimitedRepresentation:(NSArray*)fieldDicts;

- (NSString *)formattedTaxesTotal;
- (NSNumber*)taxesTotal;
- (void)setTaxesTotal;

- (NSNumber*)taxTotalForTax:(BITax*)matchTax;

- (NSString*)applicableTaxNames;

- (void)relinkToProject:(BIProject*)aProject;

- (BIEstimateSlip*)duplicateWithoutRealTimeSlipsRelationship:(BOOL)appendCopy;

- (NSCalendarDate*)smartDate;
- (void)setSmartDate:(NSCalendarDate*)aDate;

- (NSNumber*)ratePlusMarkupMinusDiscount;
- (void)setRatePlusMarkupMinusDiscount:(NSNumber*)aRate;

- (NSDecimalNumber*)discountAsPercent;
- (NSDecimalNumber*)markupAsPercent;

- (NSNumber*)subtotalPlusMarkupMinusDiscount;
- (void)setSubtotalPlusMarkupMinusDiscount:(NSNumber*)aTotal;

- (NSString*)ratePlusMarkupMinusDiscountString;
- (void)setRatePlusMarkupMinusDiscountString:(NSString*)aString;

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (void)addTime:(long)durInSec;

- (NSArray*)plistKeys;
- (NSDictionary*)plistRepresentation;
- (void)restoreValuesFromPlist:(NSDictionary*)aDict;

- (long)realTimeSlipsTotalDurationInSeconds;
- (NSNumber*)realTimeSlipsSubtotal;
- (NSNumber*)realTimeSlipsTotal;

- (NSNumber*)totalUsedToCalculateTax:(BITax*)theTax;

- (NSString*)categoryName;
- (void)setCategoryName:(NSString*)aName;

- (NSString*)typeString;
- (void)setTypeString:(NSString*)aTypeString;

- (NSDictionary*)bexRepresentationFromTimeSlipBEXRepresentation:(NSDictionary*)timedBex;

- (NSString*)prettyEntityName;
- (void)setPrettyEntityName:(NSString*)aName;

- (BOOL)combineWithSlip:(BIEstimateSlip*)aSlip;

- (BIClient *)client;
- (void)applyRatesFromClient;
- (BOOL)rateMatchesDefaultsUsingObjectContext:(BIDatabaseObjectContext*)aContext;

- (NSString*)workerName;

- (BIEstimateSlip *)slipForMyEyesOnly;

- (BOOL)isTimedOrFlat;

- (NSNumberFormatter *)currencyFormatter;
- (BICurrency *)currency;

//- (NSCalendarDate *)dateSent;

@end
